<?php

class Vamtam_WPML_Beaver_Builder_Accordion extends WPML_Beaver_Builder_Module_With_Items {
	protected function get_title( $field ) {
		switch( $field ) {
			case 'label':
				return esc_html__( 'Accordion Item Label', 'vamtam-elements-b' );

			case 'content':
				return esc_html__( 'Accordion Item Content', 'vamtam-elements-b' );

			default:
				return '';
		}
	}
}

class Vamtam_WPML_Beaver_Builder_Tabs extends WPML_Beaver_Builder_Module_With_Items {
	protected function get_title( $field ) {
		switch( $field ) {
			case 'label':
				return esc_html__( 'Tab Label', 'vamtam-elements-b' );

			case 'content':
				return esc_html__( 'Tab Content', 'vamtam-elements-b' );

			default:
				return '';
		}
	}
}

class Vamtam_WPML_Beaver_Builder_Pricing_Table extends WPML_Beaver_Builder_Module_With_Items {

	public function &get_items( $settings ) {
		return $settings->pricing_columns;
	}

	public function get_fields() {
		return array( 'title', 'button_text', 'button_url', 'features', 'price', 'duration' );
	}

	protected function get_title( $field ) {
		switch ( $field ) {
			case 'title':
				return esc_html__( 'Pricing table: Title', 'vamtam-elements-b' );

			case 'button_text':
				return esc_html__( 'Pricing table: Button text', 'vamtam-elements-b' );

			case 'button_url':
				return esc_html__( 'Pricing table: Button link', 'vamtam-elements-b' );

			case 'btn_icon':
				return esc_html__( 'Pricing table: Button icon', 'vamtam-elements-b' );

			case 'features':
				return esc_html__( 'Pricing table: Feature', 'vamtam-elements-b' );

			case 'price':
				return esc_html__( 'Pricing table: Price', 'vamtam-elements-b' );

			case 'duration':
				return esc_html__( 'Pricing table: Duration', 'vamtam-elements-b' );

			default:
				return '';

		}
	}

	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'button_url':
				return 'LINK';

			case 'features':
				return 'VISUAL';

			case 'title':
			case 'button_text':
			case 'price':
			case 'duration':
			default:
				return 'LINE';
		}
	}
}

class Vamtam_WPML_Beaver_Builder_Icon_Group extends WPML_Beaver_Builder_Module_With_Items {

	public function &get_items( $settings ) {
		return $settings->icons;
	}

	public function get_fields() {
		return array( 'link' );
	}

	protected function get_title( $field ) {
		switch ( $field ) {
			case 'link':
				return esc_html__( 'Icon link', 'vamtam-elements-b' );

			default:
				return '';

		}
	}

	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'link':
				return 'LINK';

			default:
				return '';
		}
	}

}