<?php

add_filter( 'wpml_beaver_builder_modules_to_translate', 'vamtam_wpml_beaver_builder_modules_to_translate' );
function vamtam_wpml_beaver_builder_modules_to_translate( $modules ) {
	if ( ! class_exists( 'FLBuilderModel' ) ) {
		return $modules;
	}

	foreach ( FLBuilderModel::$modules as $slug => $module ) {
		if ( strpos( $slug, 'vamtam-' ) === 0 ) {
			$fields = [];

			foreach ( $module->form as $tab_id => $tab ) {
				if ( isset( $tab['sections'] ) ) {
					foreach ( $tab['sections'] as $section_id => $section ) {
						if ( isset( $section['fields'] ) ) {
							foreach( $section['fields'] as $field_id => $field ) {
								$label = $field['label'] ?: $section['title'];

								if ( isset( $field['vamtam-wpml'] ) ) {
									$fields[] = [
										'field'       => $field_id,
										'type'        => $label,
										'editor_type' => $field['vamtam-wpml'],
									];
								} elseif ( $field['type'] === 'editor' ) {
									$fields[] = [
										'field'       => $field_id,
										'type'        => $label,
										'editor_type' => 'VISUAL',
									];
								} elseif ( $field['type'] === 'link' ) {
									$fields[] = [
										'field'       => $field_id,
										'type'        => $label,
										'editor_type' => 'LINE',
									];
								}
							}
						}
					}
				}
			}

			if ( ! empty( $fields ) ) {
				$modules[ $slug ] = [
					'conditions' => [ 'type' => $slug ],
					'fields' => $fields,
				];
			}

		}
	}

	if ( ! isset( $modules['vamtam-accordion'] ) ) {
		$modules['vamtam-accordion'] = [
			'conditions' => [ 'type' => 'vamtam-accordion' ],
			'fields'     => '',
		];
	}

	$modules['vamtam-accordion']['integration-class'] = 'Vamtam_WPML_Beaver_Builder_Accordion';

	if ( ! isset( $modules['vamtam-tabs'] ) ) {
		$modules['vamtam-tabs'] = [
			'conditions' => [ 'type' => 'vamtam-tabs' ],
			'fields'     => '',
		];
	}

	$modules['vamtam-tabs']['integration-class'] = 'Vamtam_WPML_Beaver_Builder_Tabs';

	if ( ! isset( $modules['vamtam-pricing-table'] ) ) {
		$modules['vamtam-pricing-table'] = [
			'conditions' => [ 'type' => 'vamtam-pricing-table' ],
			'fields'     => '',
		];
	}

	$modules['vamtam-pricing-table']['integration-class'] = 'Vamtam_WPML_Beaver_Builder_Pricing_Table';

	if ( ! isset( $modules['vamtam-icon-group'] ) ) {
		$modules['vamtam-icon-group'] = [
			'conditions' => [ 'type' => 'vamtam-icon-group' ],
			'fields'     => '',
		];
	}

	$modules['vamtam-icon-group']['integration-class'] = 'Vamtam_WPML_Beaver_Builder_Icon_Group';


	return $modules;
}
